-----------------------------------------------------------------------
--
--  MISR A JOUR DE LA STRUCTURE DDS QUOTAS
--
-----------------------------------------------------------------------

-----------------------------------------------------------------------
--MODIFY STRATUM TABLE, Drop all constraints from stratum
-----------------------------------------------------------------------
begin
	declare @sql varchar(1024)
	declare curs cursor for
		  select 'ALTER TABLE '+tab.name+' DROP CONSTRAINT '+cons.name
		  from sys.objects cons,sys.objects tab
		  where cons.type in ('C', 'F', 'PK', 'UQ', 'D')
		  and cons.parent_object_id=tab.object_id and tab.type='U' and tab.name = 'Stratum'
		  order by cons.type
	open curs;
	fetch next from curs into @sql
	while (@@fetch_status = 0)
	begin
		  exec(@sql)
		  fetch next from curs into @sql
	end
	close curs
	deallocate curs
end
go

-----------------------------------------------------------------------
--MODIFY QuotaAgent TABLE, Drop all constraints from stratum
-----------------------------------------------------------------------
begin
	declare @sql varchar(1024)
	declare curs cursor for
		  select 'ALTER TABLE '+tab.name+' DROP CONSTRAINT '+cons.name
		  from sys.objects cons,sys.objects tab
		  where cons.type in ('C', 'F', 'PK', 'UQ', 'D')
		  and cons.parent_object_id=tab.object_id and tab.type='U' and tab.name = 'QuotasAgent'
		  order by cons.type
	open curs;
	fetch next from curs into @sql
	while (@@fetch_status = 0)
	begin
		  exec(@sql)
		  fetch next from curs into @sql
	end
	close curs
	deallocate curs
end
go
 

-----------------------------------------------------------------------
--MODIFY QUOTA TABLE, DROP THE ACTUAL PRIMARY KEY TO CREATE A NEW ONE
-----------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.all_objects AS o 
	INNER JOIN sys.tables AS t ON t.[object_id]=o.[parent_object_id]
	WHERE o.[type]='PK' AND o.[name]='PK_Quota')
ALTER TABLE Quota DROP CONSTRAINT PK_Quota
go
 
IF  NOT EXISTS( select * from sys.columns where Name = N'QtQuotaId' and Object_ID = Object_ID(N'Quota'))
BEGIN
      ALTER TABLE Quota ADD QtQuotaId int IDENTITY NOT NULL
END
GO

ALTER TABLE Quota ADD CONSTRAINT PK_Quota PRIMARY KEY (QtQuotaId)
go



-----------------------------------------------------------------------
-- ADD a new column StrQuotaId to STRATUM 
-----------------------------------------------------------------------
IF  NOT EXISTS( select * from sys.columns where Name = N'StrQuotaId' and Object_ID = Object_ID(N'Stratum'))
BEGIN
      ALTER TABLE Stratum ADD StrQuotaId int NULL;
END
GO

 

-----------------------------------------------------------------------
-- POPULATE THE NEWLY CREATED StrQuotaId COLUMN
-----------------------------------------------------------------------
UPDATE Stratum SET Stratum.StrQuotaId = Quota.QtQuotaId
      FROM  Stratum inner join Quota on Stratum.StrStratum = Quota.QtStratum
go

-- delete orphean Startum
delete from Stratum where StrQuotaId is null
go

-----------------------------------------------------------------------
--RECREATE STARTUM PRIMARY KEY AND STRATUM to QUOTA FOREIGN KEY
-----------------------------------------------------------------------
--RECREATE FK [FK_StratumAndQuota]
ALTER TABLE Stratum  WITH NOCHECK ADD CONSTRAINT [FK_StratumAndQuota] FOREIGN KEY([StrQuotaId])
REFERENCES Quota (QtQuotaId)
ON UPDATE CASCADE
ON DELETE CASCADE
go

ALTER TABLE Stratum CHECK CONSTRAINT [FK_StratumAndQuota]
go

--RECREATE FK [FK__StratumAndRespondent]
ALTER TABLE Stratum  WITH NOCHECK ADD  CONSTRAINT [FK__StratumAndRespondent] FOREIGN KEY([StrRespondent])
REFERENCES Respondent (ResRespondent)
ON UPDATE CASCADE
ON DELETE CASCADE
go

ALTER TABLE Stratum CHECK CONSTRAINT [FK__StratumAndRespondent]
go

 

--RECREATE Primary Key
ALTER TABLE Stratum ALTER COLUMN  StrQuotaId int NOT NULL;
go

ALTER TABLE Stratum ADD  CONSTRAINT [PK_Stratum] PRIMARY KEY CLUSTERED 
(
      StrQuotaId ASC,
      StrRespondent ASC
) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
go



-----------------------------------------------------------------------
--UPDATE QuotaAgent Table
-----------------------------------------------------------------------

--add the new column
IF  NOT EXISTS( select * from sys.columns where Name = N'QuotaId' and Object_ID = Object_ID(N'QuotasAgent'))
BEGIN
      ALTER TABLE QuotasAgent ADD QuotaId int NULL;
END
GO


--populate the new column QuotaId
UPDATE QuotasAgent SET QuotasAgent.QuotaId = Quota.QtQuotaId
      FROM  QuotasAgent inner join Quota on QuotasAgent.Stratum = Quota.QtStratum
go

--delete orphan QuotaAgent
delete from QuotasAgent where QuotaId is null


--add the fk with cascade
ALTER TABLE QuotasAgent  WITH NOCHECK ADD CONSTRAINT [FK_QuotasAgentAndQuota] FOREIGN KEY([QuotaId])
REFERENCES Quota (QtQuotaId)
ON UPDATE CASCADE
ON DELETE CASCADE
go


ALTER TABLE QuotasAgent CHECK CONSTRAINT [FK_QuotasAgentAndQuota]
go

 
--make the now column not null
ALTER TABLE QuotasAgent ALTER COLUMN  QuotaId int NOT NULL;
go

--create the new pk
ALTER TABLE QuotasAgent ADD  CONSTRAINT PK_QuotasAgent PRIMARY KEY CLUSTERED 
( QuotaId ASC, AgentId ASC ) WITH ( PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
go

